/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.tiviacz.pizzacraft.blockentity.PizzaBlockEntity;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.system.MemoryStack;

@OnlyIn(value=Dist.CLIENT)
public class BlockAlphaRenderer
extends ModelBlockRenderer {
    private static BlockAlphaRenderer INSTANCE;

    public static BlockAlphaRenderer getInstance(ModelBlockRenderer baseRenderer) {
        if (INSTANCE == null || BlockAlphaRenderer.INSTANCE.f_110995_ != baseRenderer.f_110995_) {
            INSTANCE = new BlockAlphaRenderer(baseRenderer);
        }
        return INSTANCE;
    }

    public BlockAlphaRenderer(ModelBlockRenderer baseRenderer) {
        super(baseRenderer.f_110995_);
    }

    public static void renderBlockAlpha(BlockPos pos, BlockState state, Level level, PoseStack poseStack, MultiBufferSource buffer, ModelData data) {
        poseStack.m_85836_();
        BlockRenderDispatcher blockDispatcher = Minecraft.m_91087_().m_91289_();
        BlockAlphaRenderer renderer = BlockAlphaRenderer.getInstance(blockDispatcher.m_110937_());
        renderer.tesselateBlock((BlockAndTintGetter)level, blockDispatcher.m_110910_(state), state, pos, poseStack, buffer.m_6299_(RenderType.m_110466_()), false, level.f_46441_, state.m_60726_(pos), OverlayTexture.f_118083_, data, null);
        poseStack.m_85849_();
    }

    public void m_111023_(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quadIn, float tintA, float tintB, float tintC, float tintD, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn) {
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        if (quadIn.m_111304_()) {
            int i = Minecraft.m_91087_().m_91298_().m_92577_(state, level, pos, quadIn.m_111305_());
            r = (float)(i >> 16 & 0xFF) / 255.0f;
            g = (float)(i >> 8 & 0xFF) / 255.0f;
            b = (float)(i & 0xFF) / 255.0f;
        }
        float alpha = 1.0f;
        if (level.m_7702_(pos) instanceof PizzaBlockEntity) {
            PizzaBlockEntity tileEntity = (PizzaBlockEntity)level.m_7702_(pos);
            alpha = 1.0f - (float)tileEntity.getLeftBakingTime() / (float)tileEntity.getBakingTime();
        }
        BlockAlphaRenderer.addTransparentQuad(pose, quadIn, new float[]{tintA, tintB, tintC, tintD}, r, g, b, new int[]{brightness0, brightness1, brightness2, brightness3}, combinedOverlayIn, true, consumer, alpha);
    }

    public static void addTransparentQuad(PoseStack.Pose pose, BakedQuad quad, float[] colorMuls, float r, float g, float b, int[] vertexLights, int combinedOverlayIn, boolean mulColor, VertexConsumer consumer, float alpha) {
        int[] vertexData = quad.m_111303_();
        Vec3i faceVector3i = quad.m_111306_().m_122436_();
        Vector3f faceVector = new Vector3f((float)faceVector3i.m_123341_(), (float)faceVector3i.m_123342_(), (float)faceVector3i.m_123343_());
        Matrix4f matrix = pose.m_85861_();
        faceVector.m_122249_(pose.m_85864_());
        int vertexDataEntries = vertexData.length / 8;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int vertexIndex = 0; vertexIndex < vertexDataEntries; ++vertexIndex) {
                intbuffer.clear();
                intbuffer.put(vertexData, vertexIndex * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                float red = colorMuls[vertexIndex] * r;
                float green = colorMuls[vertexIndex] * g;
                float blue = colorMuls[vertexIndex] * b;
                if (mulColor) {
                    float redMultiplier = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float greenMultiplier = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float blueMultiplier = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    red = redMultiplier * red;
                    green = greenMultiplier * green;
                    blue = blueMultiplier * blue;
                }
                int light = consumer.applyBakedLighting(vertexLights[vertexIndex], bytebuffer);
                float texU = bytebuffer.getFloat(16);
                float texV = bytebuffer.getFloat(20);
                Vector4f posVector = new Vector4f(x, y, z, 1.0f);
                posVector.m_123607_(matrix);
                consumer.applyBakedNormals(faceVector, bytebuffer, pose.m_85864_());
                consumer.m_5954_(posVector.m_123601_(), posVector.m_123615_(), posVector.m_123616_(), red, green, blue, alpha, texU, texV, combinedOverlayIn, light, faceVector.m_122239_(), faceVector.m_122260_(), faceVector.m_122269_());
            }
        }
    }
}

